using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Schema;

namespace Transform
{
    public class clsXMLmessage
    {
        XmlSchema myXmlSchema;
        XmlTextWriter myXmlTextWriter;

        public clsXMLmessage(XmlSchema myXmlSchema, XmlTextWriter myXmlTextWriter) 
        {
            this.myXmlSchema = myXmlSchema;
            this.myXmlTextWriter = myXmlTextWriter;
        }

        public void buildXMLmessage()
        {
            foreach (XmlSchemaElement element in myXmlSchema.Elements.Values)
                buildXMLmessageElement(element);
        }

        // Write some example elements
        public void buildXMLmessageElement(XmlSchemaElement element)
        {
            myXmlTextWriter.WriteStartElement(element.QualifiedName.Name, element.QualifiedName.Namespace);
            if (element.ElementType is XmlSchemaComplexType)
            {
                XmlSchemaComplexType type = (XmlSchemaComplexType)element.ElementType;
                if (type.ContentModel != null)
                {
                    if (type.ContentModel is XmlSchemaSimpleContent)
                    {
                        XmlSchemaSimpleContent simpleContent = (XmlSchemaSimpleContent)type.ContentModel;
                        if(simpleContent.Content is XmlSchemaSimpleContentExtension)
                        {
                            buildXMLmessageAttributes(((XmlSchemaSimpleContentExtension)simpleContent.Content).Attributes); 
                        }
                    }
                    else
                    {
                    }
                }
                buildXMLmessageAttributes(type.Attributes);
                buildXMLmessageParticle(type.Particle);
            }
            else
                buildXMLmessageValue();

            myXmlTextWriter.WriteEndElement();
        }

        // Write some example attributes
        public void buildXMLmessageAttributes(XmlSchemaObjectCollection attributes)
        {
            foreach (object o in attributes)
            {
                if (o is XmlSchemaAttribute)
                    buildXMLmessageAttribute((XmlSchemaAttribute)o);
                else
                {
                    XmlSchemaAttributeGroup group = (XmlSchemaAttributeGroup)myXmlSchema.Groups[((XmlSchemaAttributeGroupRef)o).RefName];
                    buildXMLmessageAttributes(group.Attributes);
                }
            }
        }

        // Write a single example attribute
        public void buildXMLmessageAttribute(XmlSchemaAttribute attribute)
        {
            myXmlTextWriter.WriteStartAttribute(attribute.QualifiedName.Name, attribute.QualifiedName.Namespace);
            // The examples value
            buildXMLmessageValue();
            myXmlTextWriter.WriteEndAttribute();
        }

        // Write example particles
        public void buildXMLmessageParticle(XmlSchemaParticle particle)
        {
            if (particle == null)
            {
                buildXMLmessageValue();
                return;
            }

            if (particle is XmlSchemaElement)
                buildXMLmessageElement((XmlSchemaElement)particle);
            else if (particle is XmlSchemaSequence)
            {
                foreach (XmlSchemaParticle particle1 in ((XmlSchemaSequence)particle).Items)
                    buildXMLmessageParticle(particle1);
            }
            else
                Console.WriteLine("Not Implemented for this type: {0}", particle.ToString());        
        }

        // Write the examples text values
        public void buildXMLmessageValue()
        {
            myXmlTextWriter.WriteString(" data ");  
        }
    }
}
